'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) 2005  Microsoft Corporation.  All rights reserved.
'***********************************************************************

' **********************************************************
' CmdMail.vbs 
' Description: 	Sends email using the CDO Interfaces built into 
'				Windows Server 2003
'
' In:  	-t <to address> 
' 		-f <from address> 
' 		-s <subject> 
' 		-b <message body> 
' 		-m <smart host> 
' 		-h <html>
' Out: none
' **********************************************************

' Modified to use remote mail server instead of the local host

Option Explicit

' Define Variables
Dim iMsg			' the message
Dim iConf			' the confirmation
Dim Flds			' fields collection
Dim strHTML			' HTML String added to the Body
Dim oArgs			' Script CommandLine Arguments
Dim ArgNum			' Number of Arguments supplied
Dim strTo			' the recipient(s) suppy more then one delimted by semicolon
Dim strFrom			' the sender
Dim strSubject		' the subject
Dim strBody			' the Plain Text Body
Dim strFormat		' Message Format definition
Dim strSmartHost	' the mail server to use to send this of	

' get the command line arguments
Set oArgs = WScript.Arguments
' reset the arguments counter to 0
ArgNum = 0

' iterate through the arguments collection and pick 
' the ones we need
' this could also be achieved by using the arguments.named() collection
' see http://www.microsoft.com/scripting for details
While ArgNum < oArgs.Count - 1
	' get the relevant arguments
	' we use LCase to normalize the input to 
	' all lowercase
	Select Case LCase(oArgs(ArgNum))
		Case "-to","-t":
			' increase the counter
			ArgNum = ArgNum + 1
			' get the Recipient(s)
			strTo = oArgs(ArgNum)
		Case "-from","-f":
			' increase the counter
			ArgNum = ArgNum + 1
			' get the Sender
			strFrom = oArgs(ArgNum)
		Case "-subject","-s":
			' increase the counter
			ArgNum = ArgNum + 1
			' get the Subject
			strSubject = oArgs(ArgNum)
		Case "-body","-b":
			' increase the counter
			ArgNum = ArgNum + 1
			' get the body
			strBody = oArgs(ArgNum)
		Case "-mail","-m":
			' increase the counter
			ArgNum = ArgNum + 1
			' get the mailFormat
			strSmartHost = oArgs(ArgNum)
		Case "-html","-h":
			' increase the counter
			ArgNum = ArgNum + 1
			' get the HTML
			strFormat = oArgs(ArgNum)
		Case "-help","-?":
			' Display the usage
			Call DisplayUsage
		Case Else:
			' in case an invalid parameter is passed 
			' Display the Usage
			Call DisplayUsage
	End Select
	' Increase the counter
	ArgNum = ArgNum + 1
Wend
' If we did not get the required input paramaters, display the usage and bail out
If oArgs.Count=0 Or strTo="" Or strFrom="" Or strSubject="" Or strBody="" or strSmartHost="" Then
	Call DisplayUsage
Else         
	' Set constant for Standard SMTP Network usage
	' Set to 1 if you prefer to use the Pickup Directory instead
	Const cdoSendUsingPort = 2
	' create the Message Object
	set iMsg = CreateObject("CDO.Message")
	' Create the configuration Object
	set iConf = CreateObject("CDO.Configuration")
	' Create the Configuration Fields Collection
	Set Flds = iConf.Fields
	' now go through the Fields Collection and set
	' the required Options
	With Flds
		' Set the send TimeOut
		.Item("http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout") = 10
		' Define we are sending using the Network
		.Item("http://schemas.microsoft.com/cdo/configuration/sendusing") = cdoSendUsingPort
		' Define the server name to use
		.Item("http://schemas.microsoft.com/cdo/configuration/smtpserver") = strSmartHost
		' set the Authentication to NTLM
		.Item("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 2'cdoNTLM
		' Update the Fields Collection
		.Update
	End With 
	' start creating a HTML Body
	' this is ignored further down if an no Message Format
	' has been supplied.
	strHTML = "<HTML>"
	strHTML = strHTML & "<HEAD>"
	strHTML = strHTML & "<BODY>"
	' Define the Font
	strHTML = strHTML & "<span style='font-size:10.0pt;font-family:Arial'>"
	' insert the Body string
	strHTML = strHTML & strBody
	strHTML = strHTML & "</span>"
	strHTML = strHTML & "</BODY>"
	strHTML = strHTML & "</HTML>"
	' now populate the Message Object's Properties
	With iMsg
		' Get the Message Configuration Collection
		Set .Configuration = iConf
		' Set the Recipient
		.To = strTo
		' Set the sender
		.From = strFrom
		' Set the subject
		.Subject = strSubject
		' if no Format has been supplied add
		' the default Body
		If strFormat="" Then
			.HTMLBody = strBody
		Else
			' The format was set so we insert 
			' the HTML
			.HTMLBody = strHTML
		End If
		' Send the message
		.Send
	End With
	' Clean up the variables and objects
	Set iMsg = Nothing
	Set iConf = Nothing
	Set Flds = Nothing
	Set strHTML = Nothing
	Set oArgs = Nothing
	Set ArgNum = Nothing
	Set strTo = Nothing
	Set strFrom = Nothing
	Set strSubject = Nothing
	Set strBody = Nothing
	Set strFormat = Nothing
	Set strSmartHost = Nothing

End If

Sub DisplayUsage
' Displays basic usage information
	WScript.Echo "Cmdmail Usage:" & (Chr(13)) & (Chr(13)) & "cmdmail -t <to address> -f <from address> -s <subject> -b <message body> -m <smart host> -h <html>" & (Chr(13)) & (Chr(13)) & "cmdmail -t (required) -f (required) -s (required) -b (required) -m (required) -h (optional)" & (Chr(13)) & (Chr(13)) & "Display Usage: cmdmail -?"
	WSCript.Quit
End Sub